function [nj,J]= computenj(n,N);
% Syntax: function [nj,J]= computenj(n,N);
% Objective:	Compute the number of wavelet coefficients for each individual scale
% Input:
%       n : total number of samples
%       N : filter length.
% Output:
%       nj : number of wavelet coefficients at each individual scale
%       nj(1)= number of observations (finest scale)
%       J : total number of scales 
%
% Authors: Gilles Fay, Eric Moulines, Franois Roueff. 

nj(1)=n;
J=2;
while ((nj(J-1)-N +1) >= 1)
    nj(J)= ceil((nj(J-1)-N+1)/2);
    J= J+1;
end   
J= J-2;
nj = nj(2:end);
return
