rng(685131489); % fix the seed of the generator

% Choice of the parameters of simulation
J = 9;
N = 2^J;

d = [0.2 0.4];
k = length(d);
rho = 0.4;	% correlation coefficient between u1 and u2
cov = [1 rho; rho 1];	% covariance matrix of (u1,u2)
r = chol(cov);	

VAR = [0.8 0.2; 0 0.6];
VMA = [];
fivar = 1;

[x, long_run_cov, d] = varfima(N, d, cov, VAR, VMA, fivar);


%%%%%%%%%%% Fourier-based estimation
m = floor(N^0.65); % default value of Shimotsu
[d_mfw, cov_mfw] = mfw(x,m);


%%%%%%%%%%% Wavelet-based estimation 

% Compute wavelets
[qmf, M, alpha] = scalingfilter('Daubechies',8);
% Range of scale for the estimation
LU = [2,J]; 

% Estimation using directly the time series
[d_mww, cov_mww] = mww(x,qmf,LU);


% Using the wavelet decomposition of the time series

% Wavelet decomposition (this is also included in the functions without _wav)
xwav = zeros(N,k);
for j=1:k
    xx = x(:,j);
    [xwav_temp,index,Jmax] = DWTexact(xx,qmf);
    xwav(1:index(Jmax),j) = xwav_temp;
end
% we free some memory
if (index(Jmax)<N)
    xwav((index(Jmax)+1):N,:) = [];
end;
index = [0 index];

% Fourier transform of qmf
[psih, grid_psih]= psi_hat_exact(qmf,round(log2(N)));

% Extimation using xwav 
[d_mww_wav, cov_mww_wav] = mww_wav(xwav,index,psih,grid_psih,LU);

