function [d, g] = mfw(x,m)
% mfw.m computes the multivariate Fourier Whittle estimators
% of the long-range dependence parameters and the lon-run covariance matrix
%
% 		INPUT	x: data (nxk vector)
%			m: truncation number
%
%				       based on the codes of Shimotsu (2007)
%						      Achard & Gannaz (2014)
%___________________________________________________________________________

[~, k] = size(x);

d = fminsearch('mfw_eval',zeros(k,1),[],x,m);
g = mfw_cov(d,x,m);


end

