function [r] = mfw_eval(d,x,m)
% mfw_eval.m computes the multivariate Fourier Whittle criterion 
% 
% 		INPUT	x: data (nxk vector)
%			m: truncation number
%			d: kx1 parameter value
%
%				       based on the codes of Shimotsu (2007)
%						      Achard & Gannaz (2014)
%___________________________________________________________________________

[n,k] = size(x);
t = (0:1:n-1)';
lambda = 2*pi*t/n;

wx = zeros(n,k);
for j=1:k
    xx = x(:,j);
    wx(:,j) = (2*pi*n)^(-1/2)*conj(fft(xx)).*exp(1i*lambda);
end
wx = wx(2:m+1,:);

lambda = lambda(2:m+1);
llambda = zeros(m,k);
for j=1:k
    llambda(:,j) = lambda.^d(j).*exp((lambda-pi)*d(j)*1i/2);
end
 
lw = llambda.*wx;
g = transpose(lw)*conj(lw)/m;
rg = real(g);

r = log(det(rg)) - 2*sum(d)*mean(log(lambda));

end
