function [d, g] = mww_wav(xwav,index,psih,grid_psih,LU)
% multi_wav_exact.m computes the multivariate Wavelet Whittle criterion 
% for the estimation of the long-memory parameter at value d, with exact 
% DWT of Faÿ et al (2009).
%
% 
% 	INPUT	d 	kx1 parameter value
%               x	data (nxk vector)
%		filter  the wavelet filter
%               LU	the first and maximal resolution level used for 
%               	estimation in wavelet decomposition (optional)
%				
%                                                Achard & Gannaz (2014)
%______________________________________________________________________

[~, k] = size(xwav);

d = fminsearch('mww_wav_eval',zeros(k,1),[],xwav,index,LU);
g = mww_wav_cov(d,xwav,index,psih,grid_psih,LU);

end
