function [r] = mww_wav_eval(d,xwav,index,LU)
% mww_wav.m computes the multivariate Wavelet Whittle criterion 
% for the estimation of the long-memory parameter at value d,
% given the wavelet coefficients.
% 
% 		INPUT	d       kx1 parameter value
%               xwav	vector of the wavelet coefficients
%			    index   indexes of xwav corresponding to changes of scales
%               LU      the first and maximal resolution level used for 
%               		estimation in wavelet decomposition (optional)
%				
%                                          		     Achard & Gannaz (2014)
%__________________________________________________________________________________

[~, k] = size(xwav);
Jmax = length(index)-1;

% Wavelet scales
if (nargin<=3)
    LU = [1 Jmax];
end

L = max(LU(1),1);
U = min(LU(2),Jmax);
nscale = U-L+1;

n = index(U+1)-index(L);

% Estimation of G
sum_xwav = zeros(nscale,k,k);
vect = zeros(nscale,1);
for f=1:nscale
	j = L+f-1;
	fj = 1-j;
	temp = xwav((index(j)+1):index(j+1),:)*diag(2.^(fj*d));
	sum_xwav(f,:,:) = transpose(temp)*temp;
	vect(f) = fj*(index(j+1)-index(j));
end;
g_temp = sum(sum_xwav,1);
g = zeros(k,k);
g(:,:) = g_temp(1,:,:);
g = real(g);    
 
% criterion
r = log(det(g)) - 2*sum(d)*log(2)*sum(vect)/n;


end
