function [psih, grid_psi] = psi_hat_exact(qmf,J)
% psi_hat_exact.m computes the discrete Fourier transform
% of the wavelet associated to the filter qmf
%
% The wavelet is given by the function makescalingfunction of Faÿ et al
% (2009).
%
% The length of the Fourier transform is equal to the length of the grid
% where the wavelet is evaluated
%
% 		INPUT	qmf: quadratic mirror filter of the wavelet
%               J: number of points where the wavelet is evaluated
%
%                                           	   Achard & Gannaz (2014)
%________________________________________________________________________

Jmax = J-3;

[~,psi] = makescalingfunction(qmf,J,0);
L = length(psi);
psi = psi(:)/sqrt(2^J); % normalization

Nfft = 2^nextpow2(L);
Te = (length(qmf)-1)*2^Jmax; % support-size, with correction due to the exact DWT
psi = [psi; zeros(Nfft-L,1)];
psih = fft(psi,Nfft)/sqrt(pi*Te);

grid_psi = pi*Te*[((1/Nfft):(1/Nfft):1/2) ((-1/2):(1/Nfft):(-1/Nfft)) ]';

end
