function x = varma(N, k, VAR, VMA, cov_matrix, innov)

% Generates N observations of a k-vector ARMA process
%
%   INPUT   N           Number of time points
%           k           Dimension of the vectorial ARMA
%           VAR         Array of VAR coefficient matrices (optional)
%           VMA         Array of VMA coefficient matrices (optional)
%           cov_matrix	Matrix of covariance between the innovations (optional, default is identity)
%           innov       Matrix of the innovations (optional, default is a gaussian process)
%         
% OUTPUT                Vector containing the N observations of the k-vector ARMA process
%
%										Achard & Gannaz (2014)
%____________________________________________________________________________________________________

if(nargin<=4)
	cov_matrix = eye(k);
end;
if(nargin<=5)
	innov = randn(N+2000,k);
	innov = innov*chol(cov_matrix);
end;

[nn,kk] = size(innov);
if(kk~=k)
	warning('The dimension of the innovations mismatch')
end;

[kar1, kar2, nar] = size(VAR);
[kma1, kma2, nma] = size(VMA);
if(isempty(VAR)==0)
	if((kar1~=k)||(kar2~=k))
		warning('The dimension of AR does not match')
	end;
end;
if(isempty(VMA)==0)
	if((kma1~=k)||(kma2~=k))
		warning('The dimension of MA does not match')
	end;
end;


% simulate the data
u0 = innov;
if(isempty(VMA)==0)
	for i=(nma+1):nn
		for lag=1:nma
			u0(i,:) = u0(i,:) + innov(i-lag,:)*VMA(:,:,lag);
		end;
	end;
end;	
u1 = u0;
if(isempty(VAR)==0)
	for i=(nar+1):nn
		for lag=1:nar
			u1(i,:) = u1(i,:) - u1(i-lag,:)*VAR(:,:,lag);
		end;
	end;
end;
u1 = u1((nn-N+1):nn,:);


x=u1;

end

