'''
    **SUMMARY** Track blobs coordinates in a fixed plan movie given as
    an argument, or webcam stream.  It creates a csv file with the
    same name, containing the coordinates of the blobs (in arbitrary
    order, some reordering might be necessary) and a jpg file merging
    all the shots.

    **PARAMETERS**

    * *mov* - is the filename of the movie to analyse. 
    
    **EXAMPLE**

    python trackBlobs.py myVideo.mov
    python trackBlobs.py  - for live webcam version

    or in the console:

    trackBlobs('/path/to/myVideo.mov')
    trackBlobs()

'''

import cv2
import numpy as np
import sys, os, getopt


def trackBlobs(name="track",cam=None,blobMinsize=10,blobMaxsize=10000,stretchMin=1,stretchMax=40):
    if not(name=="track"):
		ext = os.path.splitext(name)[1]
		if (ext==".mov" or ext==".avi") and not(cam):
			cam = cv2.VideoCapture(name)
    else: cam = cv2.VideoCapture(0) #webcam
    if cam.isOpened(): # try to get the first frame
        rval, img = cam.read()
    else:
        rval = False
    fgbg = cv2.BackgroundSubtractorMOG() # Background subtractor
    
    # Setup SimpleBlobDetector parameters.
    params = cv2.SimpleBlobDetector_Params()
 
    # Change thresholds
    params.minThreshold = stretchMin;
    params.maxThreshold = stretchMax;
 
    # Filter by Color.
    params.filterByColor = True
    params.blobColor = 255 # light blobs on a black background
    
    # Filter by Area.
    params.filterByArea = True
    params.minArea=blobMinsize
    params.maxArea=blobMaxsize
    params.minDistBetweenBlobs = 10
    params.filterByInertia = False
    params.filterByConvexity = False
    params.filterByCircularity = False

    # Set up the detector
    detector = cv2.SimpleBlobDetector(params)

	# Comma Separated Version file log
    f = open(name+'.csv','w')

    # the frame
    cv2.namedWindow("preview")
	# the number of the frame
    t=0
    #try:
    while rval:
        key = cv2.waitKey(20)
        if key in [27, ord('Q'), ord('q')]: # exit on ESC
                break
            # Apply the background substraction
        imd = fgbg.apply(img) # cv2.bitwise_not(
            # Detect blobs.
        blobs = detector.detect(imd)
            # Draw detected blobs as red circles.
            #cv2.DRAW_MATCHES_FLAGS_DRAW_RICH_KEYPOINTS ensures the size of the circle corresponds to the size of blob
        img = cv2.drawKeypoints(img, blobs, np.array([]), (0,0,255))#, cv2.DRAW_MATCHES_FLAGS_DRAW_RICH_KEYPOINTS)
        if blobs:
            f.write(str(t))
            for b in blobs:
                #print b.size
                x, y = b.pt
                f.write(','+str(x)+','+str(y))
            f.write('\n')
        t+=1
        cv2.imshow("preview",img)
        rval, img = cam.read()
    f.close()
    cv2.destroyAllWindows()
    cam.release()
        
def main():
	# parse command line optio
            try:
                opts, args = getopt.getopt(sys.argv[1:], "h", ["help"])
            except getopt.error, msg:
                print msg
                print "for help use --help"
                sys.exit(2)
            # process options
            for o, a in opts:
                if o in ("-h", "--help"):
                    print __doc__
                    sys.exit(0)
            # process arguments
            if args:
                for arg in args:
                    trackBlobs(name = os.path.splitext(arg)[0])
                    sys.exit(0)
            #trackBlobs("/Users/christianmercat/Movies/P1090696.mov")
            trackBlobs()

if __name__ == "__main__":
        main()
