function u0 = kellersegelic(x)
% KELLERSEGELIC Initial conditions for Keller-Segel equations
%
%   See also: KELLERSEGEL, KELLERSEGELBC
%
%   Ecole de Printemps SFBT 2012

c = 0.5;
d = 0.4;
u0 = [1/d*(x>=-c-d).*(x<=-c+d)+1/d*(x>=c-d).*(x<=c+d); 0];