import java.applet.Applet;
import java.awt.*;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.RenderingHints;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DecimalFormat;
import javax.swing.*;
import javax.swing.event.MouseInputAdapter;

import quicktime.QTException;
import quicktime.QTSession;

import de.jtem.mathExpr.ExpressionConfiguration;
import de.jtem.mathExpr.evaluator.Variable;
import de.jtem.mathExpr.evaluator.complexEvaluator.ComplexType;
import de.jtem.mfc.field.Complex;

import com.sun.image.codec.jpeg.ImageFormatException;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;

/**
 * An applet to let the user browse an image, display it and map it by a holomorphic map.
 * First, locate a picture on your space, then choose a function, whether by clicking on the
 * proposed examples, or by entering your own expression f(z)=. Then watch in the range space, 
 * the pixel z colored by the image you chose as a target space, at the pixel f(z). 
 * You can drag the blue point z
 * and see how f(z) (as well blue) changes in the original picture (the target space).
 * 
 * @author Christian Mercat and Lalit Ramesh Sirsikar
 * 
 *
 */
/**
 * @author christianmercat
 *
 */
public class WebCamConfExpo extends Applet implements ActionListener,
											Runnable, ItemListener {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;


	/**
	 * The thickness of the stroke
	 */
	public static final int thickness = 2;
	
	/**
	 * The original image obtained from the webcam
	 * 
	 * @link #lc.
	 */
	BufferedImage originalBuff;

	/**
	 * Width and height of
	 * 
	 * @link #originalBuff
	 */
	int x0, y0;

	/**
	 * Container for
	 * 
	 * @link #originalBuff
	 */
	final JFrame originalF = new JFrame("Espace d'arrive");

	/**
	 * Container for
	 * 
	 * @link #final
	 */
	final JFrame finalF = new JFrame("Espace de dpart (bougez les points rouge et bleu)");
	
	/**
	 * The transformed image, computed by
	 * 
	 * @link #calculImage().
	 */
	BufferedImage finalBuff;
	

	/**
	 * Width and height of
	 * 
	 * @link #finalBuff
	 */
	int x1, y1;
	
	/**
	 * to create draggable points on the final image
	 */
	Point2D.Double z_Start = new Point2D.Double();
	Point2D.Double z_End = new Point2D.Double();
	Marker z_start = new Marker(z_Start);
	Marker z_end = new Marker(z_End);
	
	Point2D.Double fz_Start = new Point2D.Double();
	Marker fz_start = new Marker(fz_Start);
	Point2D.Double fz_End = new Point2D.Double();
	Marker fz_end = new Marker(fz_End);
	
	
	/**
	 * to create transparent layer on the images so that dragging is allowed
	 */
	JLayeredPane layeredPaneF; // The layered pane containing:
	JLabel finalL; // 1. The image
	JLabel finalT; // 2. The transparent layer
	JPanel finalPanel; // The panel displaying the layered pane.
	
	JLayeredPane layeredPaneO;
	Component originalL;
	JLabel originalT;
	JPanel originalPanel;
	
	final ImageIcon finalImage = new ImageIcon();
	
	BufferedImage originalImage;
	/**
	 * The configuration (type, variables...) of the expression for the function
	 * to apply.
	 */
	public ExpressionConfiguration config = new ExpressionConfiguration(
			ComplexType.TYPE);

	public ExpressionConfiguration configPoly;

	/**
	 * The expression of the function, the width and height of the final image.
	 */
	TextField expression, width, height;//, sleep;

	/**
	 * The complex value to be mapped by the function.
	 */
	Complex z = new Complex();

	/**
	 * The variable attached to the complex value
	 * 
	 * @link #z .
	 */
	Variable zVar;


	private LiveCam lc;


	
	/**
	 * Computes the value of a given expression configuration, at a given point z_0 
	 * 
	 * @param config
	 * @param z_0
	 * @param k
	 * @return
	 */

	public Complex value(ExpressionConfiguration con, Complex z_0) {
		final Complex fz = new Complex();
		zVar.setValue(z_0);
		try {
			fz.assign((Complex) con.evaluateExpression());
		} catch (Exception e) {
			// e.printStackTrace();
			fz.assign(z);
		}
		// Puts the evaluation of f(z) into fz.
		return fz;
	}
	
	public void initWebcam(int x, int y) throws Exception {
		QTSession.close();
		try {
			QTSession.open();
		} catch (QTException qte) {
			qte.printStackTrace();
				}
		lc = new LiveCam(x,y);

		lc.startPreviewing();
		x0 = lc.getImageSize().getWidth();
		y0 = lc.getImageSize().getHeight();
		if (originalL != null) layeredPaneO.remove(originalL);
		
		originalL = lc.buildSwingCameraView();
		

		
		originalL.setSize(x0,y0);
		originalL.setVisible(true);
		originalL.validate();
		layeredPaneO.add(originalL, 1);
		layeredPaneO.setBounds(100, 100, x0, y0);
		originalBuff = lc.image;
	}
//	final JFrame test = new JFrame("webcam");
	/**
	 * Draws a button and the text fields to start the job.
	 * 
	 * @see java.applet.Applet#init()
	 */
	public void init() {
		init(640,480);
	}
	
	public void init(int x, int y) {
		x1 = x; y1 = y; // The size of the windows
		final int hx = x >> 1, hy = y >>1;

		z_start.setLocation(hx, hy);
		z_end.setLocation(hx*3/2, hy/2);

		fromPoint(z_0, z_start);
      	fromPoint(z_1, z_end);

/**-------------------------------------------------------------*/
		finalF.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		finalF.setBounds(0, -20, x0, y0);
		finalF.setAlwaysOnTop(true);
        finalPanel = new JPanel();
        layeredPaneF = new JLayeredPane();
        
        finalL = new JLabel(finalImage);
        finalT = new FinalCurve();
        layeredPaneF.add(finalL,1);
        layeredPaneF.add(finalT,0);
        
        finalPanel.add(layeredPaneF);
        finalF.setContentPane(finalPanel);
		//finalF.setUndecorated(true);
        finalF.setVisible(true);
/**-------------------------------------------------------------*/

        originalF.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        
        originalPanel = new JPanel();
		         layeredPaneO = new JLayeredPane();
        
 
		try {
			initWebcam(x, y); // Instantiates originalL and adds it to layeredPaneO
		} catch (Exception e) {
			System.out.println("Pas de webcam dtecte");
			e.printStackTrace();
			loadImage();
		}


		originalT = new OriginalCurve();
		originalT.setSize(x0, y0);

		layeredPaneO.add(originalT,0);
		layeredPaneO.setSize(x0, y0);
	
//		test.add(layeredPaneO);
//		test.pack();
//		test.setBounds(100, 100, x0, y0);
//		test.setVisible(true);

//		originalPanel.add(layeredPaneO);
//		originalPanel.setVisible(true);
//		originalPanel.setSize(x0, y0);
//		originalPanel.validate();
		originalF.add(layeredPaneO);//originalPanel);
		originalF.setAlwaysOnTop(true);
		originalF.setBounds(0, 500, x0, y0);
		originalF.setVisible(true);
		originalF.validate();
/**-------------------------------------------------------------*/
		
		setLayout(new GridLayout(12, 1));
		Button buttonL = new Button("Charger une image  dformer");
		buttonL.addActionListener(this);
		// add(buttonL); // Pas pour l'expo.

		Panel expPanel = new Panel();

		expPanel.add(new Label("f(z)="));
		
		// The expressions of the functions among which to choose.
		funcs = new String[471-316+1]; // Line numbers
		int i = 0;
		
		funcs[i++] = "z";
		funcs[i++] = "1.5*z";
		funcs[i++] = "2*z";
		funcs[i++] = "1.5*z";
		funcs[i++] = "z";
		funcs[i++] = "0.75*z";
		funcs[i++] = "z/2";
		funcs[i++] = "z/4";
		funcs[i++] = "z/16";
		funcs[i++] = "-z/16";
		funcs[i++] = "-z/4";
		funcs[i++] = "-z/2";
		funcs[i++] = "-z";
		funcs[i++] = "-2*z";
		funcs[i++] = "2*exp(5*i*Pi/6)*z";
		funcs[i++] = "1.5*exp(2*i*Pi/3)*z";
		funcs[i++] = "i*z";
		funcs[i++] = "exp(i*Pi/3)*z";
		funcs[i++] = "(1+i)*z";
		funcs[i++] = "2*exp(i*Pi/6)*z";
		funcs[i++] = "2*z";
		funcs[i++] = "2*(z^1.125)";
		funcs[i++] = "2*(z^1.25)";
		funcs[i++] = "2*(z^1.325)";
		funcs[i++] = "2*(z^1.5)";
		funcs[i++] = "2*(z^1.75)";
		funcs[i++] = "2*z^2";
		funcs[i++] = "2*z^2";
		funcs[i++] = "2*(z^2.25)";
		funcs[i++] = "2*(z^2.5)";
		funcs[i++] = "2*(z^2.75)";
		funcs[i++] = "2*(z^3)";
		funcs[i++] = "2*(z^3)";
		funcs[i++] = "2*(z^3.5)";
		funcs[i++] = "2*(z^4)";
		funcs[i++] = "2*(z^4.5)";
		funcs[i++] = "2*(z^5)";
		funcs[i++] = "2*(z^7)";
		funcs[i++] = "2*(z^9)";
		funcs[i++] = "2*(z^8)";
		funcs[i++] = "2*(z^6)";
		funcs[i++] = "2*(z^3)";
		funcs[i++] = "2*(z^2.5)";
		funcs[i++] = "2*(z^2)";
		funcs[i++] = "2*(z^1.5)";
		funcs[i++] = "2*z";
		funcs[i++] = "2*(z^0.875)";
		funcs[i++] = "2*(z^0.75)";
		funcs[i++] = "2*(z^0.666)";
		funcs[i++] = "2*(z^0.5)";
		funcs[i++] = "2*(z^0.4)";
		funcs[i++] = "2*(z^0.333)";
		funcs[i++] = "2*(z^0.25)";
		funcs[i++] = "2*(z^0.125)";
		funcs[i++] = "2/(z^0.125)";
		funcs[i++] = "2/(z^0.25)";
		funcs[i++] = "2/(z^0.333)";
		funcs[i++] = "2/(z^0.5)";
		funcs[i++] = "2/(z^0.75)";
		funcs[i++] = "2/z";
		funcs[i++] = "1.5/z";
		funcs[i++] = "1/z";
		funcs[i++] = "0.7/z";
		funcs[i++] = "0.3/z";
		funcs[i++] = "0.16/z";
		funcs[i++] = "0.08/z";
		funcs[i++] = "0.16/z";
		funcs[i++] = "0.3/z";
		funcs[i++] = "0.7/z";
		funcs[i++] = "1/z";
		funcs[i++] = "2/z";
		funcs[i++] = "4/z";
		funcs[i++] = "2/z";
		funcs[i++] = "1/z";
		funcs[i++] = "0.5/z";
		funcs[i++] = "0.5/(z-0.25)";
		funcs[i++] = "0.375/(z-0.5)";
		funcs[i++] = "0.25/(z-0.75)";
		funcs[i++] = "0.125/(z-1)";
		funcs[i++] = "0.5/(4*z^2-4)";
		funcs[i++] = "0.51/(4*z^2-2)";
		funcs[i++] = "0.51/(4*z^2-1)";
		funcs[i++] = "0.51/(4*z^2-0.5)";
		funcs[i++] = "0.51/(4*z^2-0.25)";
		funcs[i++] = "0.51/(4*z^2-0.125)";
		funcs[i++] = "0.51/(4*z^2)";
		funcs[i++] = "0.251/(4*z^2)";
		funcs[i++] = "0.1251/(4*z^2)";
		funcs[i++] = "0.251/(4*z^2)";
		funcs[i++] = "0.51/(4*z^2)";
		funcs[i++] = "1/(4*z^2)";
		funcs[i++] = "2/(4*z^2)";
		funcs[i++] = "-5*(z^3/3-z/4)/2";
		funcs[i++] = "2*z^4+4*(1-i)*z^3/3-(1+i)*z^2-z";
		funcs[i++] = "exp(9*z)";
		funcs[i++] = "exp(8*z)";
		funcs[i++] = "exp(7*z)";
		funcs[i++] = "exp(Pi*z)";
		funcs[i++] = "exp(Pi*(1+i)*z/1.414)";
		funcs[i++] = "exp(Pi*i*z)";
		funcs[i++] = "exp(-Pi*i*z)";
		funcs[i++] = "cos(z*Pi)";
		funcs[i++] = "1-(z*Pi)^2/2+(z*Pi)^4/24+(z*Pi)^6/720-(z*Pi)^8/40320";
		funcs[i++] = "cos(z*Pi)";
		funcs[i++] = "exp(Pi*i*z)";
		funcs[i++] = "exp(-Pi*i*z)";
		funcs[i++] = "sin(z*Pi)";
		funcs[i++] = "(z*Pi)-(z*Pi)^3/6+(z*Pi)^5/120-(z*Pi)^7/5040";
		funcs[i++] = "sin(z*Pi)";
		funcs[i++] = "exp(Pi*i*z)";
		funcs[i++] = "(sin(z*Pi))/(cos(z*Pi))";
		funcs[i++] = "z*Pi+(z*Pi)^3/3+2*(z*Pi)^5/15+17*(z*Pi)^7/315";
		funcs[i++] = "(sin(z*Pi))/(cos(z*Pi))";
		funcs[i++] = "exp(Pi*i*z)";
		funcs[i++] = "exp(Pi*(1+i)*z)";
		funcs[i++] = "exp(7*z)";
		funcs[i++] = "1+7*z+49*z^2/2";
		funcs[i++] = "8*log(z)*(240/320)/(Pi)";
		funcs[i++] = "8*log(z)*2*(240/320)/(Pi)";
		funcs[i++] = "8*log(z)*4*(240/320)/(Pi)";
		funcs[i++] = "8*log(z)*2*(240/320)/(Pi)";
		funcs[i++] = "8*log(z)*(240/320)/(Pi)";
		funcs[i++] = "8*log(z)*(240/320+i/3)/(Pi)";
		funcs[i++] = "8*log(z)*(240/320+2*i/3)/(Pi)";
		funcs[i++] = "8*log(z)*(240/320+i)/(Pi)";
		funcs[i++] = "8*log(z)*(240/320+1.5*i)/(Pi)";
		funcs[i++] = "8*log(z)*(240/320+2*i)/(Pi)";
		funcs[i++] = "8*log(z)*(240/320+3*i)/(Pi)";
		funcs[i++] = "8*log(z)*(240/320+2*i)/(Pi)";
		funcs[i++] = "8*log(z)*(240/320+1.5*i)/(Pi)";
		funcs[i++] = "8*log(z)*(240/320+i)/(Pi)";
		funcs[i++] = "8*log(z)*(240/320+0.5*i)/(Pi)";
		funcs[i++] = "8*log(z)*(240/320)/(Pi)";
		funcs[i++] = "8*log(z)*(240/320-0.5*i)/(Pi)";
		funcs[i++] = "8*log(z)*(240/320-i)/(Pi)";
		funcs[i++] = "8*log(z)*(240/320-1.5*i)/(Pi)";
		funcs[i++] = "8*log(z)*(240/320-2*i)/(Pi)";
		funcs[i++] = "8*log(z)*(240/320-3*i)/(Pi)";
		funcs[i++] = "6*(log(z))*(240/320-3*i)/(Pi)";
		funcs[i++] = "4*(log(z))*(240/320-3*i)/(Pi)";
		funcs[i++] = "2*(log(z))*(240/320-3*i)/(Pi)";
		funcs[i++] = "(log(z))*(240/320-3*i)/(Pi)";
		funcs[i++] = "(log(z-1/2)+log(z))*(240/320-3*i)/(Pi)";
		funcs[i++] = "(log(z-1/2)+log(z+1/2)+log(z))*(240/320-3*i)/(Pi)";
		funcs[i++] = "(log(z-1/2)+log(z+1/2)+log(z-i/2)+log(z))*(240/320-3*i)/(Pi)";
		funcs[i++] = "(log(z-1/2)+log(z+1/2)+log(z-i/2)+log(z+i/2)+log(z))*(240/320-3*i)/(Pi)";
		funcs[i++] = "(log(z-1/2)+log(z+1/2)+log(z-i/2)+log(z+i/2))*(240/320-3*i)/(Pi)";
		funcs[i++] = "(log(z-1/2)+log(z+1/2)+log(z-i/2)+log(z+i/2)-log(z))*(240/320-3*i)/(Pi)";
		funcs[i++] = "8*log(z)*240/(Pi*320)";
		funcs[i++] = "8*((z-1)-(z-1)^2/2+(z-1)^3/3+(z-1)^4/4-(z-1)^5/5+(z-1)^6/6-(z-1)^7/7)*240/(Pi*320)";
		funcs[i++] = "8*log(z)*240/(Pi*320)";
		funcs[i++] = "exp(7/z)";
		funcs[i++] = "exp(10/z)";
		funcs[i++] = "exp(20/z)";
		funcs[i++] = "exp(40/z)";
		funcs[i++] = "exp(80/z)";

		
		expression = new TextField("sin(z*Pi)", 30);

		expression.addActionListener(this);
		expPanel.add(expression);

		add(expPanel);
		
		zVar = config.defineVariable("z", z, ComplexType.TYPE);
		
		config.setExpression(expression.getText());
		



		Panel simple = new Panel();

		Button id = new Button("z");
		id.addActionListener(this);
		simple.add(id);

		Button dz = new Button("2 z");
		dz.addActionListener(this);
		simple.add(dz);

		Button mz = new Button("-z");
		mz.addActionListener(this);
		simple.add(mz);

		Button iz = new Button("i z");
		iz.addActionListener(this);
		simple.add(iz);

		Button irz = new Button("(1+i) z");
		irz.addActionListener(this);
		simple.add(irz);

		add(simple);
		Panel simple2 = new Panel();

		Button z2 = new Button("z^2");
		z2.addActionListener(this);
		simple2.add(z2);

		Button z3 = new Button("z^3");
		z3.addActionListener(this);
		simple2.add(z3);

		Button inv = new Button("1/z");
		inv.addActionListener(this);
		simple2.add(inv);

		Button bip = new Button("bipole");
		bip.addActionListener(this);
		simple2.add(bip);

		add(simple2);

		Panel poly = new Panel();

		Button poly1 = new Button("Poly1");
		poly1.addActionListener(this);
		poly.add(poly1);

		Button poly2 = new Button("Poly2");
		poly2.addActionListener(this);
		poly.add(poly2);

		Button inv2 = new Button("1/z^2");
		inv2.addActionListener(this);
		poly.add(inv2);

		Button frac = new Button("Fraction");
		frac.addActionListener(this);
		poly.add(frac);

		add(poly);

		Panel transc = new Panel();

		Button exp = new Button("exp");
		exp.addActionListener(this);
		transc.add(exp);

		Button log = new Button("log");
		log.addActionListener(this);
		transc.add(log);

		Button spirale1 = new Button("spirale1");
		spirale1.addActionListener(this);
		transc.add(spirale1);

		Button spirale2 = new Button("spirale2");
		spirale2.addActionListener(this);
		transc.add(spirale2);

		Button spirale3 = new Button("spirale3");
		spirale3.addActionListener(this);
		transc.add(spirale3);

		add(transc);

		Panel taylor = new Panel();

		Button taylor_exp = new Button("Taylor exp");
		taylor_exp.addActionListener(this);
		taylor.add(taylor_exp);

		Button taylor_log = new Button("Taylor log");
		taylor_log.addActionListener(this);
		taylor.add(taylor_log);

		Button prod_exp = new Button("Prod exp");
		prod_exp.addActionListener(this);
		taylor.add(prod_exp);

		add(taylor);

		Panel circ = new Panel();

		Button cos = new Button("cos");
		cos.addActionListener(this);
		circ.add(cos);

		Button sin = new Button("sin");
		sin.addActionListener(this);
		circ.add(sin);

		Button tan = new Button("tan");
		tan.addActionListener(this);
		circ.add(tan);

		add(circ);

		Panel taylCirc = new Panel();

		Button tay_cos = new Button("Taylor cos");
		tay_cos.addActionListener(this);
		taylCirc.add(tay_cos);

		Button tay_sin = new Button("Taylor sin");
		tay_sin.addActionListener(this);
		taylCirc.add(tay_sin);

		Button tay_tan = new Button("Taylor tan");
		tay_tan.addActionListener(this);
		taylCirc.add(tay_tan);

		add(taylCirc);

//		Panel refresh = new Panel();

//		refresh.add(new Label("Recalcul toutes les "));
//		sleep = new TextField("5");
//		refresh.add(sleep);
//		refresh.add(new Label(" secondes."));

//		add(refresh);

		Panel taille = new Panel();

		taille.add(new Label("Taille: ")); // Given as an argument
		width = new TextField(" "+x);// 1280");
		height = new TextField(" "+y);// 1024");
		taille.add(width);
		taille.add(height);
		width.addActionListener(this);
		height.addActionListener(this);
		add(taille);

		Button buttonS = new Button("Sauvegarder l'image dforme");
		buttonS.addActionListener(this);
		add(buttonS);

		Panel tog = new Panel();
		Checkbox decorations = new Checkbox("Dcorations");
		decorations.addItemListener(this);
		tog.add(decorations);
		Checkbox visible = new Checkbox("Points");
		visible.setState(isPointVisible);
		visible.addItemListener(this);
		tog.add(visible);
		Checkbox animation = new Checkbox("Animation");
		animation.setState(isAnimation);
		animation.addItemListener(this);
		tog.add(animation);

		add(tog);
		
		this.resize(this.getPreferredSize());

		computeImage();
		moveStartPoint();
		moveEndPoint();
		switchDecorations(); // Hides the decorations of the window
		
		Thread tr = new Thread(this);
		tr.start();
	}

	public void run() { while(true) computeImage();}

	public void saveImage() {
		FileDialog dlg = new FileDialog(finalF, "Image dforme (jpg)",
				FileDialog.SAVE);
		dlg.setVisible(true);

		String fileout = dlg.getDirectory() + dlg.getFile();

		BufferedOutputStream out = null;
		try {
			out = new BufferedOutputStream(new FileOutputStream(fileout));
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		}
		JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder(out);
		JPEGEncodeParam param = encoder.getDefaultJPEGEncodeParam(finalBuff);
		int quality = 95;
		quality = Math.max(0, Math.min(quality, 100));
		param.setQuality(quality / 100.0f, false);
		encoder.setJPEGEncodeParam(param);
		try {
			encoder.encode(finalBuff);
		} catch (ImageFormatException e1) {
			e1.printStackTrace();
		} catch (IOException e1) {
			e1.printStackTrace();
		}
		try {
			out.close();
		} catch (IOException e2) {
			e2.printStackTrace();
		}

	}

	/**
	 * Pops up a dialog to load a picture.
	 */
	private String popLoad() {
		originalF.setVisible(false);

		FileDialog dlg = new FileDialog(originalF, "Image  dformer",
				FileDialog.LOAD);
		dlg.setVisible(true);

		return dlg.getDirectory() + dlg.getFile();
	}
	/**
	 * Loads a picture, displays it and calls the
	 * computation.
	 */
	public void loadImage() {

		Toolkit toolkit = Toolkit.getDefaultToolkit();
		Image image = null;

		String	imgFile = popLoad();
		try {
			image = toolkit.createImage(imgFile);
		} catch (RuntimeException e1) {// Permissions
			image = null;
		}

		x0 = 0; y0 = 0;

		while((x0<0)||(x0*y0 <= 0)||(x0*y0> 1E7)){
			MediaTracker mediaTracker = new MediaTracker(this);
			mediaTracker.addImage(image, 0);
			try {
				mediaTracker.waitForID(0);
			} catch (InterruptedException ie) {
				System.err.println(ie);
			}

			if(image != null) {
				x0 = image.getWidth(null);
				y0 = image.getHeight(null);
			}

			if (x0 <= 0) try { // Not a valid image file
				try {
					loadImage();
					originalF.pack();
					originalF.setVisible(true);
					return;
				} catch (Exception e1) {
image = toolkit.createImage(new URL("http://ens.math.univ-montp2.fr/SPIP/IMG/jpg/frise320x240.jpg"));
					x0 = image.getWidth(null);
					y0 = image.getHeight(null);
				}
			} catch (MalformedURLException e) {
				e.printStackTrace();
			}
		}

		Graphics2D graphics2D;

		if (true || (originalBuff == null)
				|| (originalBuff.getHeight() != y0)
				|| (originalBuff.getWidth() != x0)) {
			originalBuff = new BufferedImage(x0, y0,
					BufferedImage.TYPE_INT_RGB);
			graphics2D = originalBuff.createGraphics();
			graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION,
					RenderingHints.VALUE_INTERPOLATION_BILINEAR);
		} else
			graphics2D = (Graphics2D) originalBuff.getGraphics();

		graphics2D.drawImage(image, 0, 0, null);


		if ((x0 > 0) && (y0 > 0)) {
			
			originalImage = originalBuff;
			
			layeredPaneO.setPreferredSize(new Dimension(x0,y0));
			
			
			if (originalL != null) layeredPaneO.remove(originalL);
			originalL = new JLabel(new ImageIcon(originalImage));
			layeredPaneO.add(originalL, 1);
	        
			originalT.setBounds(0, 0, x0, y0);
			originalT.setBackground(Color.BLACK);
	        originalT.setBorder(BorderFactory.createTitledBorder("Lalit"));
	        
	        MouseHandlers handler = new MouseHandlers();
	        originalT.addMouseMotionListener(handler);
	        
			originalPanel.add(layeredPaneO);
			
			originalF.setContentPane(originalPanel);
			originalF.pack();
			originalF.repaint();
			originalF.setVisible(true);
		}
	}

	/**
	 * Computes the deformation and displays it.
	 */
	
	public void computeImage() {

		final Complex z = new Complex();
		final Complex fz = new Complex();
		
		if ((x0 > 0) && (y0 > 0)) { // Else in the process of loading an image
			int x0p = x0;
			int y0p = y0; // In case they change if a new picture is loaded. 
			x1 = Integer.parseInt(width.getText().trim());
			y1 = Integer.parseInt(height.getText().trim());

			if ((x1 * y1 == 0) || (x1 * y1 > 4000000)) {
				x1 = 800;
				y1 = 600;
			}
			
			if ((finalBuff == null) || (finalBuff.getHeight() != y1)
					|| (finalBuff.getWidth() != x1)) {
				finalBuff = new BufferedImage(x1, y1, BufferedImage.TYPE_INT_RGB);	
			}
			
			if(isAnimation && (compteur++ % repet ==0)){ // Take the next function in the list.
				expression.setText(funcs[theFunc++]);
				theFunc %= funcs.length;}
			
			String str = expression.getText();
			try { // If expression is not finished, it throws
				config.setExpression(str);
			} catch (Exception e) {
				config.setExpression("z"); // Identity map
			}
			
			for (int x = 0; x < x1; x++)
				for (int y = 0; y < y1; y++)
			{	
					
					fromPoint(z, x,  y);
					
					fz.assign(value(config, z));
					
					// Put fz in pixel coords.
					modBack(fz);				
					
					final int r = (int) fz.re;
					final int i = (int) fz.im;

					// Entre -1. et 1.
					final double r_l = fz.re - r;
					final double i_l = fz.im - i;
					
					final int r0 = (r + ((r_l>0)?1:x0p-1)) % x0p;
					final int i0 = (i + ((i_l>0)?1:y0p-1)) % y0p;
					
					try {
						finalBuff.setRGB(x, y, moyenne(moyenne(originalBuff
								.getRGB(r, i), originalBuff.getRGB(r, i0), Math
								.abs(i_l)), moyenne(originalBuff.getRGB(r0, i),
								originalBuff.getRGB(r0, i0), Math.abs(i_l)), Math.abs(r_l)));
					} catch (Exception e) {
					}
				}
			
			finalImage.setImage(finalBuff);
			
			layeredPaneF.setPreferredSize(new Dimension(x1,y1));
			
			finalL.setIcon(finalImage);
	        finalL.setBounds(0, 0, x1, y1);
//	        finalL.setBackground(Color.RED);
	        
	        
	        finalT.setBounds(0, 0, x1, y1);
//	        finalT.setBackground(Color.BLACK);
	        finalT.setBorder(BorderFactory.createTitledBorder("Lalit"));

	        MouseHandlers handler = new MouseHandlers();
	        finalT.addMouseListener(handler);
	        finalT.addMouseMotionListener(handler);
	        
	        finalPanel.add(layeredPaneF);

//	        finalF.setContentPane(finalPanel);
	        finalF.pack();
	        finalF.repaint();
//	        finalF.setVisible(true);
		}
	}
	
	
	/**
	 * start point
	 */
	Complex z_0 = new Complex();
	
	/**
	 * end point
	 */
	Complex z_1 = new Complex();
		
	/**
	 * value at start point
	 */
	Complex fz_0 = new Complex();
	/**
	 * value at end point
	 */
	Complex fz_1 = new Complex();


	/**
	 * Whether the original frame has decorations.
	 */
	private boolean isDeco=false;


	/**
	 * Whether the red and blue points are visible
	 */
	private boolean isPointVisible = false;

	/**
	 * Whether the functions are random
	 */
	private boolean isAnimation = true;

	private int compteur = 0;
	private int repet = 3;
	/**
	 * The functions to choose from
	 */
	private String[] funcs;
	private int theFunc = 0;
	
	
	/**
	 * Assigns to the Complex z the position given by the finalBuffer pixel coordinates. 
	 * Translates by hx1,hy1, conjugates and scales by 1/hx1.
	 * @param z
	 * @param m
	 */
	public void fromPoint(Complex z, Marker m) {
		fromPoint(z, m.getX(), m.getY());	
	}
	public void fromPoint(Complex z, double x, double y) {
		final int hx1 = x1 >> 1; 		final int hy1 = y1 >> 1;
		z.assign((1. * x - hx1)/ hx1 ,(hy1-1. * y)/ hx1 );	
	}

	/**
	 * transforms a Complex to an originalBuffer pixel coordinate view of itself. Scales by half the horizontal size, conjugate and translates the
	 * middle point to 0.
	 * @param f
	 */
	public void toPixel(Complex f) {
		final int hx0 = x0 >> 1;		final int hy0 = y0 >> 1;
		final int hx1 = x1 >> 1;
		
		f.assignTimes(hx1);	f.assignConjugate(); f.assignPlus(hx0, hy0);
	}
	/**
	 * maps back the image of f(z) to the original rectangle in the complex
	 * plane i.e. in the original image here used to calculate for individual
	 * functions - used in moveStartPoint() and move EndPoint()
	 * 
	 * @param f -
	 *            the value of the function to map back - Complex value i.e.
	 *            mapped back to the image in pixel coordinates, between 0 and
	 *            x0 for x and between 0 and y0 for y.
	 */
	public Complex modBack(Complex f) {
		
		toPixel(f);

		final Complex mB = subtractFactor(f);
		
		f.assignMinus(mB); 
		
		return mB;
	}
	
	/**
	 * returns how much pixels to subtract to be in the original image once already in pixel coordinates.
	 * the graphics.
	 * @param f
	 * @return
	 */
	public Complex subtractFactor(Complex f) {
		final Complex c = new Complex();
		subtractFactor(f,c);
		return c;
	}
	public void subtractFactor(Complex f, Complex result) {
		
		int r = (int) f.re;				int i = (int) f.im;

		int q_r = r / x0;
		int q_i = i / y0;
		

		if ((q_r < 0)||((q_r==0) && r<0))
			q_r -= 1;
		if ((q_i < 0)||((q_i==0) && i<0))
			q_i -= 1;

		result.assign(q_r*x0, q_i*y0);

	}

	/**
	 * for point z_0
	 */
	public void moveStartPoint() {
      	fromPoint(z_0, z_start);

      	fz_0.assign(value(config,z_0));
		Complex g = new Complex(fz_0);
		modBack(g);
		fz_start.setLocation(g.re, g.im);
		
		originalT.repaint();
		finalT.repaint();
	}
	
	/**
	 * for point z_1
	 */
	public void moveEndPoint() {
      	fromPoint(z_1, z_end);
		
		fz_1.assign(value(config,z_1));
		Complex g = new Complex(fz_1);
		modBack(g);
		fz_end.setLocation(g.re, g.im);
		
		originalT.repaint();
		finalT.repaint();
	}
	

	public void itemStateChanged(ItemEvent event) {
		String c =  (String) event.getItem();
		if (c == "Animation") { 
			isAnimation = !isAnimation;
		}
		else if (c == "Points") { 
			isPointVisible = !isPointVisible;
		}
		else if (c == "Dcorations") switchDecorations();
	
		
	}
	
	/**
	 * On click: loads in the image or compute its deformation.
	 * 
	 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
	 */
	public void actionPerformed(ActionEvent event) {
		if (event.getSource().getClass() == TextField.class) {
			String str = expression.getText();
			try { // If expression is not finished, it throws
				config.setExpression(str);
			} catch (Exception e) {
				config.setExpression("z"); // Identity map
			}
			
			computeImage();
		}
		else {
			String c = event.getActionCommand();
			if (c == "Sauvegarder l'image dforme")
				saveImage();
			else if (c == "Charger une image  dformer"){
				loadImage();
				computeImage();
				moveStartPoint();
				moveEndPoint();
			}
			else if (c.indexOf("z") != -1) {// Explicit formula
				expression.setText(c);
				computeImage();
			}
			else if (c == "1/z^2") {// Can be overridden
				expression.setText("0.08/z^2");
				
				computeImage();
			}
			else if (c == "spirale1"){
				expression.setText("log(z)*(240/320+3*i)/(2*Pi)");
				
				computeImage();
			}
			else if (c == "spirale2"){
				expression.setText("log(z)*(240/320-4*i)/(2*Pi)");
				
				computeImage();
			}
			else if (c == "spirale3"){
				expression
			.setText("(log(z-1/2)+log(z+1/2)+log(z-i/2)+log(z+i/2)+log(z))*(240/320-3*i)/(2*Pi)");
				
				computeImage();
			}
			else if (c == "bipole"){
				expression.setText("1/(4*z^2-1)");
				
				computeImage();
			}
			else if (c == "log"){
				expression.setText("8*log(z)*240/(Pi*320)");
				
				computeImage();
			}
			else if (c == "exp"){
				expression.setText("exp(7*z)");
				
				computeImage();
			}
			else if (c == "Taylor exp"){
				expression.setText("1+z+z^2/2");
				
				computeImage();
			}
			else if (c == "Taylor log"){
				expression
		.setText("((z-1)-(z-1)^2/2+(z-1)^3/3+(z-1)^4/4-(z-1)^5/5+(z-1)^6/6-(z-1)^7/7)*240/(Pi*320)");
				
				computeImage();
			}
			else if (c == "Poly1"){
				expression.setText("-5*(z^3/3-z/4)/2");
				
				computeImage();
			}
			else if (c == "Poly2"){
				expression.setText("2*z^4+4*(1-i)*z^3/3-(1+i)*z^2-z");
				
				computeImage();
			}
			else if (c == "Fraction"){
				expression.setText("((z-0.5)/(z+0.5))^2");
				
				computeImage();
			}
			else if (c == "Prod exp"){
				expression.setText("((1+z/6)/(1-z/6))^3");
				
				computeImage();
			}
			else if (c == "cos"){
				expression.setText("cos(z*Pi)");
				
				computeImage();
			}
			else if (c == "sin"){
				expression.setText("sin(z*Pi)");
				
				computeImage();
			}
			else if (c == "tan"){
				expression.setText("(sin(z*Pi))/(cos(z*Pi))");
				
				computeImage();
			}
			else if (c == "Taylor tan"){
				expression
				.setText("z*Pi+(z*Pi)^3/3+2*(z*Pi)^5/15+17*(z*Pi)^7/315");
				
				computeImage();
			}
			else if (c == "Taylor sin"){
				expression
				.setText("(z*Pi)-(z*Pi)^3/6+(z*Pi)^5/120-(z*Pi)^7/5040");
				
				computeImage();
			}
			else if (c == "Taylor cos"){
				expression
				.setText("1-(z*Pi)^2/2+(z*Pi)^4/24+(z*Pi)^6/720-(z*Pi)^8/40320");
				
				computeImage();
			}
		}
	}
	public  void switchDecorations() {
		isDeco = !isDeco;
		finalF.dispose();
		finalF.setContentPane(finalPanel);
		finalF.setVisible(false);
		finalF.setUndecorated(isDeco);
finalF.setExtendedState(javax.swing.JFrame.MAXIMIZED_BOTH);
		finalF.pack();
		finalF.setVisible(true);
	
	}
	public static int moyenne(int rgb0, int rgb1, double l) {
		int r, g, b;
		final int rflag = 255 << 16;
		final int gflag = 255 << 8;
		final int bflag = 255;
		r = ((int) (((rgb1 & rflag) - (rgb0 & rflag)) * l + (rgb0 & rflag)))& rflag;
		g = ((int) ((((rgb1 & gflag) - (rgb0 & gflag))) * l + (rgb0 & gflag)))& gflag;
		b = ((int) (((rgb1 & bflag) - (rgb0 & bflag)) * l + (rgb0 & bflag)))& bflag;
		return r + g + b;
	}
	
	public static void main(String[] args) {
		Frame f = new Frame();
		f.setVisible(true);
		WebCamConfExpo cm = new WebCamConfExpo();
		f.add(cm);
		cm.init(640,480);
		f.pack();
		f.setBounds(680, 0, 700, 500);
		}
	
	class Marker {
		public Marker() {	}
	    public Marker(Point2D.Double control) {
	      center = control; 
	      circle = new Ellipse2D.Double(control.x - radius, control.y - radius, 2.0 * radius,
	          2.0 * radius);
	    }
	    public void draw(Graphics2D g2D) {
	      g2D.draw(circle);
	    }

	    Point2D.Double getCenter() {
	      return center;
	    }
	    public boolean contains(double x, double y) {
	      return circle.contains(x, y);
	    }
	    public void setLocation(double x, double y) {
	      center.x = x; 
	      center.y = y; 
	      circle.x = x - radius; 
	      circle.y = y - radius; 
	    }

	    public double getX() {
	    	return center.x;
	    }
	    
	    public double getY() {
	    	return center.y;
	    }
	    
	    Ellipse2D.Double circle; 
	    
	    Point2D.Double center;
	    
	    static final double radius = 3;
	  }
	
	class FinalCurve extends JLabel {
		
		private static final long serialVersionUID = 2846995418991124012L;

		public FinalCurve() {}

	    public void paint(Graphics g) {
	    	if(isPointVisible) {
	      Graphics2D g2D = (Graphics2D) g;
	      g2D.setStroke(new BasicStroke(thickness));
	      
	      g2D.setPaint(Color.RED);
	      z_start.draw(g2D);
	      g2D.setPaint(Color.BLUE);
	      z_end.draw(g2D);
	    	}
	    }
	  }
	
	class OriginalCurve extends JLabel {
		
		private static final long serialVersionUID = 8945748890547508160L;

		public OriginalCurve() {	}
		
		/**
		 * mark for the start point - z_0		RED
		 * and marks[i] for sk[i] - z_1			
		 * 						marks[i]		BLUE
		 */
		public void paint(final Graphics g) {
			Graphics2D g2D = (Graphics2D) g;
			g2D.setStroke(new BasicStroke(thickness));			
				    	
		    	    	
		    g2D.setPaint(Color.RED);
		    fz_start.draw(g2D);
		    g2D.setPaint(Color.BLUE);
		    fz_end.draw(g2D);
		}
	}
	
	
	class MouseHandlers extends MouseInputAdapter {
		public void mousePressed(MouseEvent e) {
			if (z_start.contains(e.getX(), e.getY()))
				selected = z_start;
			else if (z_end.contains(e.getX(), e.getY()))
				selected = z_end;
		}
		public void mouseReleased(MouseEvent e) {
			if(selected == z_start)
				moveStartPoint();
			else if(selected == z_end)
				moveEndPoint();
			//partialSum(max-1);
			selected = null;

		}
		public void mouseDragged(MouseEvent e) {
		if (selected != null) {
			selected.setLocation(e.getX(), e.getY());
			if(selected == z_start) {
				fromPoint(z_0, z_start) ;
				moveStartPoint();
			}
			else if(selected == z_end){
				fromPoint(z_1, z_end);
				moveEndPoint();
			}
		}
		}
		public void mouseMoved(MouseEvent evt) {
			final int x = evt.getX();
			final int y = evt.getY();
			final DecimalFormat f = new DecimalFormat("+0.0000;-0.0000");
			
			if(evt.getSource().getClass() == FinalCurve.class){
				if(z_start.contains(x, y)) {
					finalT.setCursor(Cursor.getPredefinedCursor(Cursor.HAND_CURSOR));
					finalT.setToolTipText("z0 = "+f.format((z_0.re))+f.format(z_0.im)+"i");
					//+ "  Point : "+z_start.getX()+","+z_start.getY());
				}
				else if(z_end.contains(x, y)) {
					finalT.setCursor(Cursor.getPredefinedCursor(Cursor.HAND_CURSOR));
					finalT.setToolTipText("z1 = "+f.format(z_1.re)+f.format(z_1.im)+"i");
							// + "  Point : "+z_end.getX()+","+z_end.getY());
				}
				else finalT.setCursor(Cursor.getDefaultCursor());
			}
			if(evt.getSource().getClass() == OriginalCurve.class){
				originalT.setCursor(Cursor.getDefaultCursor());
				if(fz_start.contains(x, y)) {
					originalT.setCursor(Cursor.getPredefinedCursor(Cursor.CROSSHAIR_CURSOR));
					originalT.setToolTipText("f(z0) = "+f.format(fz_0.re)+f.format(fz_0.im)+"i");
							//+ "  Point : "+fz_end.getX()+","+fz_end.getY());
				}				
				else if(fz_end.contains(x, y)) {
					originalT.setCursor(Cursor.getPredefinedCursor(Cursor.CROSSHAIR_CURSOR));
					originalT.setToolTipText("f(z1) = "+f.format(fz_1.re)+f.format(fz_1.im)+"i");
							//+ "  Point : "+fz_end.getX()+","+fz_end.getY());
				}				
}
		}
		Marker selected = null;
	}


}
