import java.applet.Applet;
import java.awt.Button;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.RenderingHints;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;

import quicktime.QTException;
import quicktime.QTSession;

import mathExpr.ExpressionConfiguration;
import mathExpr.evaluator.Variable;
import mathExpr.evaluator.complexEvaluator.ComplexType;
import mfc.field.Complex;

import com.sun.image.codec.jpeg.ImageFormatException;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;

/**
 * An applet to let the user browse an image, display it and map it by a holomorphic map.
 * 
 * @author mercat@math.univ-montp2.fr
 * 
 *  
 */
/**
 * @author mercat
 * 
 * To change the template for this generated type comment go to Window -
 * Preferences - Java - Code Generation - Code and Comments
 */
public class ComplexMap extends Applet implements ActionListener, Runnable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * The originale image obtained from the webcam
	 * 
	 * @link #lc.
	 */
	BufferedImage originaleBuff;

	/**
	 * Width and height of
	 * 
	 * @link #originaleBuff
	 */
	int x0, y0;

	/**
	 * Container for
	 * 
	 * @link #originaleBuff
	 */
	final JFrame originaleF = new JFrame("Originale");

	/**
	 * Container for
	 * 
	 * @link #finale
	 */
	final JFrame finaleF = new JFrame("Finale");
	/**
	 * The transformed image, computed by
	 * 
	 * @link #calculImage().
	 */
	BufferedImage finaleBuff;

	/**
	 * Width and height of
	 * 
	 * @link #finaleBuff
	 */
	int x1, y1;

	/**
	 * Container for
	 * 
	 * @link #finaleBuff
	 */
	final ImageIcon finale = new ImageIcon();
	Component originale;
	/**
	 * The configuration (type, variables...) of the expression for the function
	 * to apply.
	 */
	public ExpressionConfiguration config = new ExpressionConfiguration(
			ComplexType.TYPE);

	/**
	 * The expression of the function, the width and height of the finale image.
	 */
	TextField expression, width, height;//, sleep;

	/**
	 * The complex value to be mapped by the function.
	 */
	Complex z = new Complex();

	/**
	 * The complex value image of
	 * 
	 * @link #z by the function.
	 */
	Complex fz = new Complex();

	/**
	 * The variable attached to the complex value
	 * 
	 * @link #z .
	 */
	Variable zVar;

	/**
	 * Computes the value of the function at a given point.
	 * 
	 * @param z0
	 *            the complex value to be mapped.
	 * @return the complex value image of the parameter by the function
	 *         described by
	 * @link #expression.
	 * 
	 * After the call, both
	 * @link #z and
	 * @link #fz are modified and hold the computation.
	 */
	public Complex valueAt(Complex z0) {
		z.assign(z0);
		return value();
	}

	/**
	 * Computes the value of the function at
	 * 
	 * @link #z.
	 * @return the complex value image of
	 * @link #z by the function described by
	 * @link #expression.
	 * 
	 * After the call,
	 * @link #fz holds the result.
	 */
	public Complex value() {
		zVar.setValue(z);
		try {
			fz.assign((Complex) config.evaluateExpression());
		} catch (Exception e) {
			// e.printStackTrace();
			fz.assign(z);
		}

		// Puts the evaluation of f(z) into fz.

		return fz;
	}

	private LiveCam lc;
	/**
	 * Draws a button and the text fields to start the job.
	 * 
	 * @see java.applet.Applet#init()
	 */
	public void init() {
		init(320,240);
	}
	public void initWebcam(int x, int y) throws Exception {
		QTSession.close();
		QTSession.open();
		lc = new LiveCam(x,y);

		lc.startPreviewing();
		if (originale != null) originaleF.remove(originale);
		originale = lc.buildSwingCameraView();
		originaleF.add(originale);
		x0 = lc.getImageSize().getWidth();
		y0 = lc.getImageSize().getHeight();
		originaleBuff = lc.image;
	}
	public void init(int x, int y) {
		originaleF.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		finaleF.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		finaleF.add(new JLabel(finale));
		finaleF.setVisible(true);	
		try {
			initWebcam(x, y);
		} catch (Exception e) {
			System.out.println("Pas de webcam dtecte");
			e.printStackTrace();
			loadImage();
		}
		originaleF.setBounds(100, 100, x0, y0);
		originaleF.setVisible(true);

		setLayout(new GridLayout(11, 1));
		Button buttonL = new Button("Charger une image  dformer");
		buttonL.addActionListener(this);
		add(buttonL);

		expression = new TextField("z^2", 50);

		expression.addActionListener(this);
		add(expression);

		zVar = config.defineVariable("z", z, ComplexType.TYPE);

		Panel simple = new Panel();

		Button id = new Button("z");
		id.addActionListener(this);
		simple.add(id);

		Button z2 = new Button("z^2");
		z2.addActionListener(this);
		simple.add(z2);

		Button inv = new Button("1/z");
		inv.addActionListener(this);
		simple.add(inv);

		Button bip = new Button("bipole");
		bip.addActionListener(this);
		simple.add(bip);

		add(simple);

		Panel poly = new Panel();

		Button poly1 = new Button("Poly1");
		poly1.addActionListener(this);
		poly.add(poly1);

		Button poly2 = new Button("Poly2");
		poly2.addActionListener(this);
		poly.add(poly2);

		Button inv2 = new Button("1/z^2");
		inv2.addActionListener(this);
		poly.add(inv2);

		Button frac = new Button("Fraction");
		frac.addActionListener(this);
		poly.add(frac);

		add(poly);

		Panel transc = new Panel();

		Button exp = new Button("exp");
		exp.addActionListener(this);
		transc.add(exp);

		Button log = new Button("log");
		log.addActionListener(this);
		transc.add(log);

		Button spirale1 = new Button("spirale1");
		spirale1.addActionListener(this);
		transc.add(spirale1);

		Button spirale2 = new Button("spirale2");
		spirale2.addActionListener(this);
		transc.add(spirale2);

		Button spirale3 = new Button("spirale3");
		spirale3.addActionListener(this);
		transc.add(spirale3);

		add(transc);

		Panel taylor = new Panel();

		Button taylor_exp = new Button("Taylor exp");
		taylor_exp.addActionListener(this);
		taylor.add(taylor_exp);

		Button taylor_log = new Button("Taylor log");
		taylor_log.addActionListener(this);
		taylor.add(taylor_log);

		Button prod_exp = new Button("Prod exp");
		prod_exp.addActionListener(this);
		taylor.add(prod_exp);

		add(taylor);

		Panel circ = new Panel();

		Button cos = new Button("cos");
		cos.addActionListener(this);
		circ.add(cos);

		Button sin = new Button("sin");
		sin.addActionListener(this);
		circ.add(sin);

		Button tan = new Button("tan");
		tan.addActionListener(this);
		circ.add(tan);

		add(circ);

		Panel taylCirc = new Panel();

		Button tay_cos = new Button("Taylor cos");
		tay_cos.addActionListener(this);
		taylCirc.add(tay_cos);

		Button tay_sin = new Button("Taylor sin");
		tay_sin.addActionListener(this);
		taylCirc.add(tay_sin);

		Button tay_tan = new Button("Taylor tan");
		tay_tan.addActionListener(this);
		taylCirc.add(tay_tan);

		add(taylCirc);

//		Panel refresh = new Panel();

//		refresh.add(new Label("Recalcul toutes les "));
//		sleep = new TextField("5");
//		refresh.add(sleep);
//		refresh.add(new Label(" secondes."));

//		add(refresh);

		Panel taille = new Panel();

		taille.add(new Label("Taille: "));
		width = new TextField(" 640 ");// 1280");
		height = new TextField(" 480 ");// 1024");
		taille.add(width);
		taille.add(height);

		add(taille);

		Button buttonS = new Button("Sauvegarder l'image dforme");
		buttonS.addActionListener(this);
		add(buttonS);

		Thread tr = new Thread(this);
		tr.start();
	}

	public void run() {
		while (true) {
			calculImage(); 
		}
	}


	public void saveImage() {
		FileDialog dlg = new FileDialog(finaleF, "Image dforme (jpg)",
				FileDialog.SAVE);
		dlg.setVisible(true);

		String fileout = dlg.getDirectory() + dlg.getFile();

		BufferedOutputStream out = null;
		try {
			out = new BufferedOutputStream(new FileOutputStream(fileout));
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		}
		JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder(out);
		JPEGEncodeParam param = encoder.getDefaultJPEGEncodeParam(finaleBuff);
		int quality = 95;
		quality = Math.max(0, Math.min(quality, 100));
		param.setQuality(quality / 100.0f, false);
		encoder.setJPEGEncodeParam(param);
		try {
			encoder.encode(finaleBuff);
		} catch (ImageFormatException e1) {
			e1.printStackTrace();
		} catch (IOException e1) {
			e1.printStackTrace();
		}
		try {
			out.close();
		} catch (IOException e2) {
			e2.printStackTrace();
		}

	}

	/**
	 * Pops up a dialog to load a picture.
	 */
	private String popLoad() {
		originaleF.setVisible(false);

		FileDialog dlg = new FileDialog(originaleF, "Image  dformer",
				FileDialog.LOAD);
		dlg.setVisible(true);

		return dlg.getDirectory() + dlg.getFile();
	}
	/**
	 * Loads a picture, displays it and calls the
	 * computation.
	 */
	public void loadImage() {

		Toolkit toolkit = Toolkit.getDefaultToolkit();
		Image image = null;

		String	imgFile = popLoad();
		try {
			image = toolkit.createImage(imgFile);
		} catch (RuntimeException e1) {// Permissions
			image = null;
		}

		x0 = 0; y0 = 0;

		while((x0<0)||(x0*y0 <= 0)||(x0*y0> 1E7)){
			MediaTracker mediaTracker = new MediaTracker(this);
			mediaTracker.addImage(image, 0);
			try {
				mediaTracker.waitForID(0);
			} catch (InterruptedException ie) {
				System.err.println(ie);
			}

			if(image != null) {
				x0 = image.getWidth(null);
				y0 = image.getHeight(null);
			}

			if (x0 <= 0) try { // Not a valid image file
				try {
					if (lc != null) 	lc.setCameraActive(false);
					initWebcam(320,200);
					originaleF.pack();
					originaleF.setVisible(true);
					return;
				} catch (Exception e1) {
					image = toolkit.createImage(new URL("http://ens.math.univ-montp2.fr/SPIP/IMG/jpg/frise320x240.jpg"));
					x0 = image.getWidth(null);
					y0 = image.getHeight(null);
				}
			} catch (MalformedURLException e) {
				e.printStackTrace();
			}
		}

		Graphics2D graphics2D;

		if (true || (originaleBuff == null)
				|| (originaleBuff.getHeight() != y0)
				|| (originaleBuff.getWidth() != x0)) {
			originaleBuff = new BufferedImage(x0, y0,
					BufferedImage.TYPE_INT_RGB);
			graphics2D = originaleBuff.createGraphics();
			graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION,
					RenderingHints.VALUE_INTERPOLATION_BILINEAR);
		} else
			graphics2D = (Graphics2D) originaleBuff.getGraphics();

		graphics2D.drawImage(image, 0, 0, null);


		if ((x0 > 0) && (y0 > 0)) {
			originaleF.remove(originale);
			originale = new JLabel(new ImageIcon(originaleBuff));
			originaleF.add(originale);
			originaleF.pack();
			originaleF.setVisible(true);
		}
	}

	/**
	 * Computes the deformation and displays it.
	 */
	public void calculImage() {

		if ((x0 > 0) && (y0 > 0)) { // Else in the process of loading an image
			int x0p = x0;
			int y0p = y0; // In case they change.
			x1 = Integer.parseInt(width.getText().trim());
			y1 = Integer.parseInt(height.getText().trim());

			if ((x1 * y1 == 0) || (x1 * y1 > 4000000)) {
				x1 = 1280;
				y1 = 1024;
			}

			final int hx0 = x0p >> 1;
			final int hy0 = y0p >> 1;
			final int hx1 = x1 >> 1;
			final int hy1 = y1 >> 1;

			if ((finaleBuff == null) || (finaleBuff.getHeight() != y1)
					|| (finaleBuff.getWidth() != x1)) {
				finaleBuff = new BufferedImage(x1, y1, BufferedImage.TYPE_INT_RGB);
			}

			try { // If expression is not finished, it throws
				config.setExpression(expression.getText());
			} catch (Exception e) {
				config.setExpression("z"); // Identity map
			}

			for (int x = 0; x < x1; x++)
				for (int y = 0; y < y1; y++) {
					z.assign((1. * x - hx1) / hx1, (1. * y - hy1) / hx1);
					value();

					fz.assignTimes(hx1);
					fz.assignPlus(hx0, hy0);

					int r = (int) fz.re;
					int i = (int) fz.im;

					// Entre -1. et 1.
					double r_l = fz.re - r;
					double i_l = fz.im - i;

					r %= x0p;
					i %= y0p;

					if (r < 0)
						r += x0p;
					if (i < 0)
						i += y0p;

					final int r_e = (r_l) > 0 ? +1 : -1;
					final int i_e = (i_l) > 0 ? +1 : -1;

					final int r0 = (r + r_e + x0p) % x0p;
					final int i0 = (i + i_e + y0p) % y0p;

					try {
						finaleBuff.setRGB(x, y, moyenne(moyenne(originaleBuff
								.getRGB(r, i), originaleBuff.getRGB(r, i0), Math
								.abs(i_l)), moyenne(originaleBuff.getRGB(r0, i),
										originaleBuff.getRGB(r0, i0), Math.abs(i_l)), Math
										.abs(r_l)));
					} catch (Exception e) {
					}
				}
			finale.setImage(finaleBuff);
			finaleF.pack();
			finaleF.repaint();
		}
	}

	/**
	 * On click: loads in the image or compute its deformation.
	 * 
	 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
	 */
	public void actionPerformed(ActionEvent event) {
		if (event.getSource().getClass() == TextField.class)
			calculImage();
		else {
			String c = event.getActionCommand();
			if (c == "Sauvegarder l'image dforme")
				saveImage();
			else if (c == "Charger une image  dformer")
				loadImage();
			else if (c == "z")
				expression.setText("z");
			else if (c == "z^2")
				expression.setText("z^2");
			else if (c == "spirale1")
				expression.setText("log(z)*(240/320+3*i)/(2*Pi)");
			else if (c == "spirale2")
				expression.setText("log(z)*(240/320-4*i)/(2*Pi)");
			else if (c == "spirale3")
				expression
				.setText("(log(z-1/2)+log(z+1/2)+log(z-i/2)+log(z+i/2)+log(z))*(240/320-3*i)/(2*Pi)");
			else if (c == "1/z")
				expression.setText("1/z");
			else if (c == "bipole")
				expression.setText("1/(4*z^2-1)");
			else if (c == "log")
				expression.setText("log(z)*240/(Pi*320)");
			else if (c == "exp")
				expression.setText("exp(z)");
			else if (c == "Taylor exp")
				expression.setText("1+z+z^2/2");
			else if (c == "Taylor log")
				expression
				.setText("((z-1)-(z-1)^2/2+(z-1)^3/3+(z-1)^4/4-(z-1)^5/5+(z-1)^6/6-(z-1)^7/7)*240/(Pi*320)");
			else if (c == "Poly1")
				expression.setText("-5*(z^3/3-z/4)/2");
			else if (c == "Poly2")
				expression.setText("2*z^4+4*(1-i)*z^3/3-(1+i)*z^2-z");
			else if (c == "Fraction")
				expression.setText("((z-0.5)/(z+0.5))^2");
			else if (c == "Prod exp")
				expression.setText("((1+z/6)/(1-z/6))^3");
			else if (c == "1/z^2")
				expression.setText("0.08/z^2");
			else if (c == "cos")
				expression.setText("cos(z*Pi)");
			else if (c == "sin")
				expression.setText("sin(z*Pi)");
			else if (c == "tan")
				expression.setText("(sin(z*Pi))/(cos(z*Pi))");
			else if (c == "Taylor tan")
				expression
				.setText("z*Pi+(z*Pi)^3/3+2*(z*Pi)^5/15+17*(z*Pi)^7/315");
			else if (c == "Taylor sin")
				expression
				.setText("(z*Pi)-(z*Pi)^3/6+(z*Pi)^5/120-(z*Pi)^7/5040");
			else if (c == "Taylor cos")
				expression
				.setText("1-(z*Pi)^2/2+(z*Pi)^4/24+(z*Pi)^6/720-(z*Pi)^8/40320");
			else { // Compute
				calculImage();
			}
		}
	}

	/**
	 * The weighted mean of two rgb colors.
	 * 
	 * @param rgb0
	 * @param rgb1
	 * @param l
	 *            between 0. and 1.
	 * @return <code>l*rgb1 + (1-l)*rgb0</code> for each channel.
	 */
	public static int moyenne(int rgb0, int rgb1, double l) {
		int r, g, b;
		final int rflag = 255 << 16;
		final int gflag = 255 << 8;
		final int bflag = 255;
		r = ((int) (((rgb1 & rflag) - (rgb0 & rflag)) * l + (rgb0 & rflag)))
		& rflag;
		g = ((int) ((((rgb1 & gflag) - (rgb0 & gflag))) * l + (rgb0 & gflag)))
		& gflag;
		b = ((int) (((rgb1 & bflag) - (rgb0 & bflag)) * l + (rgb0 & bflag)))
		& bflag;

		return r + g + b;
	}

	public void update(Graphics g) {
		paint(g);
	}

	public static void main(String[] args) {
		Frame f = new Frame();
		f.setVisible(true);
		ComplexMap cm = new ComplexMap();
		f.add(cm);
		cm.init(320,240);
		f.pack();
	}
}
