'''
    **SUMMARY** Track blobs coordinates in a fixed plan movie given as
    an argument, or webcam stream.  It creates a csv file with the
    same name, containing the coordinates of the blobs (in arbitrary
    order, some reordering might be necessary) and a jpg file merging
    all the shots.

    **PARAMETERS**

    * *mov* - is the filename of the movie to analyse. 
    
    **EXAMPLE**

    python trackBlobs.py myVideo.mov
    python trackBlobs.py  - for live webcam version

    or in the console:

    trackBlobs('/path/to/myVideo.mov')
    trackBlobs()

'''
import SimpleCV
import sys, os, getopt


def trackBlobs(cam=None,name="track"):
	if not(cam):
		cam = SimpleCV.Camera()
	# Comma Separated Version file log
	f = open(name+'.csv','w')
	# virtual camera
	display = SimpleCV.Display()
	# the starting picture
	im0 = cam.getImage().copy()
	# the final picture summing all the changes
	imf = im0
	# the number of the frame
	t=0

	try:
		while display.isNotDone():
			if display.mouseLeft: # reset
				im0= cam.getImage().copy()
				f.close()
				f = open(name+'.csv','w')
				imf = im0
				t=0
			img = cam.getImage()
			if img:
				ima = ((img - im0)+(im0-img)).stretch(15, 55)
				blobs = ima.findBlobs()
				imf += (im0-ima.invert())
				if blobs:
					for b in blobs:
						x, y = b.centroid()
						imf.drawCircle((x, y),4,SimpleCV.Color.RED,3)
						f.write(str(x)+','+str(y)+',')
					f.write(str(t)+'\n')
				t+=1
				imf.save(display)
			if display.mouseRight:
				display.done = True #if the left click is pressed, close the program
				f.close()
				imf.save(display)
				imf.save(name+'.jpg')
	except: # If the end of the movie is reached
		f.close()
		imf.save(display)
		imf.save(name+'.jpg')
def main():
	# parse command line options
	try:
		opts, args = getopt.getopt(sys.argv[1:], "h", ["help"])
	except getopt.error, msg:
		print msg
		print "for help use --help"
		sys.exit(2)
    # process options
	for o, a in opts:
		if o in ("-h", "--help"):
			print __doc__
			sys.exit(0)
			
    # process arguments
	if args:
		for arg in args:
			trackBlobs(SimpleCV.VirtualCamera(arg,'video'),name = os.path.splitext(arg)[0])
			sys.exit(0)
	trackBlobs(SimpleCV.Camera())

if __name__ == "__main__":
	main()
