'''
**SUMMARY**
Combine delayed pictures

'''
from SimpleCV import *
import sys, os, getopt

nbSlices = 60

ims = ['hb.png','rgradient.jpg','gd.png','hbbh.png','pole.png','twirl.png']
path= '/Users/christianmercat/Documents/boulot/Projets/Python/CV/'
delays = [Image(path+i).resize(160,120) for i in ims]
delays += [i.invert() for i in delays]

masks=[]


for d in delays:
	ms = []
	for i in range(0,nbSlices):
		ms +=  [d.colorDistance(color=(tuple(3*[int(i*255/(nbSlices-1))]))).binarize(thresh=255/nbSlices)]
		ms[i].show()
	masks.append(ms)

display = SimpleCV.Display(resolution = (160, 120))# (640, 480))
cam = SimpleCV.Camera(prop_set={'width':160,'height':120})#{'width':640,'height':480})

img = cam.getImage().resize(160,120).flipHorizontal()
ims = [img] * nbSlices

f=0 # The frame number
k=0 # The masks number
ms = masks[k] # The current set of masks
for i,m in enumerate(ms):
	m.show()
while display.isNotDone():
	if display.mouseLeft:
		k = (k+1) % len(masks)
		ms = masks[k]
	if display.mouseRight:
		display.done = True #if the right click is pressed, close the program
	img = cam.getImage().resize(160,120).flipHorizontal()
	if img:
		for i,m in enumerate(ms):
			j = (i+f) % nbSlices
			ims[j] = (ims[j] - m)+(img-m.invert())

		f = (f+1) % nbSlices
		ims[f].resize(640,480).show()
		

# def main():
#     # parse command line options
#     try:
#         opts, args = getopt.getopt(sys.argv[1:], "h", ["help"])
#     except getopt.error, msg:
#         print msg
#         print "for help use --help"
#         sys.exit(2)
#     # process options
#     for o, a in opts:
#         if o in ("-h", "--help"):
#             print __doc__
#             sys.exit(0)

#     # process arguments
#     if args:
# 	    for arg in args:
# 		    trackBlobs(SimpleCV.VirtualCamera(arg,'video'),name = os.path.splitext(arg)[0])
# 	    sys.exit(0)
#     trackBlobs(SimpleCV.Camera())

# if __name__ == "__main__":
#     main()
