'''
    **SUMMARY**
    Plots the webcam with its RGB histogram   
    '''
from SimpleCV import *
from SimpleCV.Display import Display

def moyHist(h):
    '''
    Spreads out frequencies on previous bins which are zeros
    '''
    nbz = 0
    mh = []
    for i, w in enumerate(h):
        nbz += 1
        if not(w == 0) or (i==(len(h)-1)):
            mh = mh + [float(w)/nbz]*nbz # repeat nbz times w/nbz
            nbz = 0
    return mh

def hist(im,h,c,m,width=-1,alpha=125):
    i=0
    mx=im.width
    my=im.height
    dx=float(mx)/255
    dy=float(my)/m
    for v in h:
        im.drawRectangle(dx*i,my-v*dy,dx,v*dy,c,width,alpha)
        i+=1

display = Display(resolution = (640, 480)) #create a new display to draw images on
cam = Camera(prop_set={'width':640,'height':480}) #initialize the camera

while not display.isDone():
    image = cam.getImage().flipHorizontal()
    (red, green, blue) = image.splitChannels(False)
    red_histogram = moyHist(red.histogram(255))
    green_histogram = moyHist(green.histogram(255))
    blue_histogram = moyHist(blue.histogram(255))
    m = max(max(red_histogram), max(green_histogram), max(blue_histogram))
    # image += image # to make it twice lighter
    hist(image,blue_histogram,SimpleCV.Color.BLUE,m)
    hist(image,red_histogram,SimpleCV.Color.RED,m)
    hist(image,green_histogram,SimpleCV.Color.GREEN,m)
    image.save(display)
    if display.mouseLeft:
        display.done = True #if the left click is pressed, close the program
#display.quit()
