'''
    **SUMMARY** meanPic in a fixed plan movie given as
    an argument, or webcam stream.  It creates a picture by removing
    all the moving elements (that don't appear on many frames)

    **PARAMETERS**

    * *mov* - is the filename of the movie to analyse. 
    
    **EXAMPLE**

    python meanPic.py myVideo.mov
    python meanPic.py  - for live webcam version

    or in the console:

    meanPic('/path/to/myVideo.mov')
    meanPic()

'''
import SimpleCV
import sys, os, getopt


def meanPic(name="track",cam=None):
	if not(name=="track"):
		ext = os.path.splitext(name)[1]
		if (ext==".mov" or ext==".avi") and not(cam):
			cam = SimpleCV.VirtualCamera(name,'video')
	if not(cam):
		cam = SimpleCV.Camera()
	# virtual camera
	display = SimpleCV.Display()
	# the starting picture
	imMean = cam.getImage().copy()
	# the number of the frame
	t=1

	try:
		while display.isNotDone():
			img = cam.getImage()
			imMean = imMean*(1.0*t/(t+3)) + img*(3.0/(t+3))
			imMean.save(display)
			t += 1
			if display.mouseLeft:
				display.done = True #if the left click is pressed, close the program
		print 'Number of frames: '+`t`
		imMean.save(name+'Mean.jpg')

	except: # If the end of the movie is reached
		print 'Number of frames: '+`t`
		return imMean.save(name+'Mean.jpg')


def main():
	# parse command line options
	try:
		opts, args = getopt.getopt(sys.argv[1:], "h", ["help"])
	except getopt.error, msg:
		print msg
		print "for help use --help"
		sys.exit(2)
    # process options
	for o, a in opts:
		if o in ("-h", "--help"):
			print __doc__
			sys.exit(0)
			
    # process arguments
	if args:
		for arg in args:
			meanPic(cam=SimpleCV.VirtualCamera(arg,'video'),name = os.path.splitext(arg)[0])
			sys.exit(0)
	meanPic()

if __name__ == "__main__":
	main()
